package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.NotificacionesDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Notificaciones;

/**
 * Ab0428t00ServiceImpl generated by UDA, 16-jun-2017 8:19:35.
 * 
 * @author UDA
 */

@Service(value = "ab0428t00Service")
public class NotificacionesServiceImpl implements NotificacionesService {

	@Autowired
	private NotificacionesDao ab0428t00Dao;

	/**
	 * Inserts a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Notificaciones add(Notificaciones ab0428t00) {
		return this.ab0428t00Dao.add(ab0428t00);
	}

	/**
	 * Updates a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Notificaciones update(Notificaciones ab0428t00) {
		return this.ab0428t00Dao.update(ab0428t00);
	}

	/**
	 * Finds a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	public Notificaciones find(Notificaciones ab0428t00) {
		return (Notificaciones) this.ab0428t00Dao.find(ab0428t00);
	}

	/**
	 * Deletes a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Notificaciones ab0428t00) {
		this.ab0428t00Dao.remove(ab0428t00);
	}

	/**
	 * Finds a list of rows in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0428t00>
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Notificaciones> findAll(Notificaciones ab0428t00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Notificaciones>) this.ab0428t00Dao.findAll(ab0428t00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0428t00 table using like.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0428t00>
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Notificaciones> findAllLike(Notificaciones ab0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Notificaciones>) this.ab0428t00Dao.findAllLike(ab0428t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(Notificaciones filterAb0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0428t00Dao.removeMultiple(filterAb0428t00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0428t00>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Notificaciones> filter(
			Notificaciones filterAb0428t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<Notificaciones> listaAb0428t00 = this.ab0428t00Dao
				.findAllLike(filterAb0428t00, jqGridRequestDto, false);
		Long recordNum = this.ab0428t00Dao
				.findAllLikeCount(filterAb0428t00 != null ? filterAb0428t00
						: new Notificaciones(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Notificaciones>> reorderSelection = this.ab0428t00Dao
					.reorderSelection(filterAb0428t00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Notificaciones>(jqGridRequestDto,
					recordNum, listaAb0428t00, reorderSelection);
		}
		return new JQGridResponseDto<Notificaciones>(jqGridRequestDto,
				recordNum, listaAb0428t00);
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.service.NotificacionesService#findAllLikeCount(com.ejie.ab04b.model.Notificaciones)
	 */
	public Long findAllLikeCount(Notificaciones filterAb0428t00) {
		return this.ab0428t00Dao.findAllLikeCount(filterAb0428t00 != null
				? filterAb0428t00 : new Notificaciones(), false);
	}

	/**
	 * Searches rows in the Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  searchAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0428t00>>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param searchAb0428t00 the search ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Notificaciones>> search(
			Notificaciones filterAb0428t00, Notificaciones searchAb0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0428t00Dao.search(filterAb0428t00, searchAb0428t00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Notificaciones filterAb0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0428t00Dao.reorderSelection(filterAb0428t00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0428t00>>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Notificaciones>> jerarquia(
			Notificaciones filterAb0428t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Notificaciones>> listaAb0428t00 = this.ab0428t00Dao
				.findAllLikeJerarquia(filterAb0428t00, jqGridRequestDto);
		Long recordNum = this.ab0428t00Dao
				.findAllLikeCountJerarquia(filterAb0428t00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Notificaciones>>(
				jqGridRequestDto, recordNum, listaAb0428t00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0428t00>>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Notificaciones>> jerarquiaChildren(
			Notificaciones filterAb0428t00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Notificaciones>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Notificaciones>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0428t00Dao.findAllChild(filterAb0428t00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
